<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$datos[0] = mysqli_real_escape_string($conn, $datos[0]);

try {
    $sql = $conn->prepare("CALL Actualiza_Stock(?)");
    $sql->bind_Param("i", $datos[0]);
    $sql->execute();

    // Comprobamos el resultado de la llamada al procedimiento almacenado
    $result = $conn->query("SELECT @nRegistros as nRegistros");
    $mensaje = $result->fetch_assoc();

    if ($mensaje['nRegistros'] > 0) {
        $resultado = array();
        $resultado['ESTADO'] = "1";
        $resultado['REGISTROS'] = $mensaje['nRegistros'];
        $resultado['MENSAJE'] = "LA INFORMACION SE ACTUALIZO CORRECTAMENTE";
        //http_response_code(200);
    } else {
        $resultado = array();
        $resultado['ESTADO'] = "0";
        $resultado['REGISTROS'] = "0";
        $resultado['MENSAJE'] = "ERROR AL ACTUALIZAR LA INFORMACIÓN: " . mysqli_error($conn);
        //http_response_code(500);
    }
} catch (Exception $e) {
    $resultado = array();
    $resultado['MENSAJE'] = "ERROR: " . $e->getMessage();
    $resultado['ESTADO'] = "0";
    $resultado['ID'] = "0";
    //http_response_code(500);
}

mysqli_close($conn);

header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>
